[**Oklahoma NG911 Toolkit**](../README.html) | [Prep] | [***Enhancement***] | [Validation] | [MSAG] | [Comparison] | [Submission]

**Supplementary Documentation** | [Examples] | [Topology Rules] | [Change Log] | [Error Glossary]

# Enhancement Toolset

## Toolset Credits
* Riley Baird, Oklahoma Transportation Cabinet
* Emma Baker, Oklahoma Transportation Cabinet

##### Last Revised:
January 09, 2025

## Abstract
These tools automate various tasks involved with data creation and/or modifications.

## Tools
### Calculate/Convert/Fix Field(s)
<span class="calculate">Calculate</span><span class="slash_str">/</span><span class="convert">Convert</span><span class="slash_str">/</span><span class="fix">Fix</span>

![Calculate/Convert/Fix](img/Example_CalculateConvertFix.png)

* Tool calculates, converts, or fixes fields in Standard feature classes. More details provided below.

#### Usage
1. Select Standard geodatabase.
2. Select analysis.
3. Select required and/or optional parameters (see below for more information).
4. Execute the tool.

<!-- ### [Generate Fishbone Analysis](FishboneAddressVerification.html)

Can be used to generate a "Dirty" Fishbone Analysis for Address Point Verification. The analysis is considered dirty, because the fishbone line shapefile is created without the user performing a quality check on the geocoded data. Ties and non-matches are simply removed from the analysis. This tool should be used as an aid to the QA/QC process and **not** as a complete quality check of the data. Address Point required fields include `City`, `State`, `Zipcode`, `Latitude`, `Longitude`, `FullAddr`, and [all fields used to calculate `FullAddr`]. Road Centerline required fields include `Add_L_From`, `Add_L_To`, `Add_R_From`, `Add_R_To`, `Parity_L`, `Parity_R`, `City_L`, `City_R`, `County_L`,`County_R`, `State_L`,`State_R`, `Zipcode_L`,`Zipcode_R`, `NGUID_RDCL`, `FullName`, and [all fields used to calculate `FullName`].

#### Usage &amp; Methodology

See the Supplementary Documentation: [Generate Fishbone Analysis Tool](FishboneAddressVerification.html#running-a-fishbone-analysis-without-the-generate-fishbone-analysis-tool). -->


---
### Calculate/Convert/Fix Field(s) - Details
---

#### Common Across Tool

##### Street Fields
* Fields include `PreMod`, `PreDir`, `PreType`, `PreTypeSep`, `Street`, `StreetType`, `SufDir`, and `SufMod`.
##### Next-Gen Fields
* Fields include `Street`, `PreTyp`, `StreetType`, `PreDir` and `SufDir`.
##### Legacy Fields
* Fields include `LgcyStreet`, `LgcyPreTyp`, `LgcyType`, `LgcyPreDir` and `LgcySufDir`.
##### Side for Roads
* Options include `LEFT` ('L') and `RIGHT` ('R')
##### Variant Options
* 'NEXT-GEN' - Use and/or Calculate [next-gen fields]
* 'LEGACY' - Use and/or Calculate [legacy fields]
---

#### <span class="calculate">Calculate</span> `FullName` and `LgcyFulSt`

* Calculates the `FullName` and `LgcyFulSt` fielda of the Address Point Standard feature class and/or the Road Centerline Standard feature class. For the `FullName` fields, the [street fields] are used with [next-gen fields], and the [legacy fields] are replaced with the Legacy version of the fields for the `LgcyFulSt` field. 

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.
* Select at least one of the [variant options] for analysis.

#### <span class="calculate">Calculate</span> `FullAddr` and `LgcyFulAdd`

* Calculates the `FullAddr` fand `LgcyFulAdd` fielda of the Address Point Standard feature class and/or the Road Centerline Standard feature class. For the `FullAddr` fields, the `AddNumPre`, `AddNumber`, `AddNumSuf`, plus the [street fields] are used, and the [legacy direction fields] and [legacy type fields] are preplaced with the Legacy version of the fields for the `LgcyFulAdd` field. 

##### Usage (con't.)

* Select at least one of the [variant options] for analysis.

#### <span class="calculate">Calculate</span> `Parity_L` and `Parity_R`

* Calculates the `Parity_`[side] fields of a road centerline feature class. The fields used for the calculation are: `Add_`[side]`_From` and `Add_`[side]`_To`. The tool will used the first and last digit on both sides to determine whether the number is `EVEN`, `ODD`, `BOTH`, or `ZERO`.

##### Usage (con't.)

* N/A

#### <span class="calculate">Calculate</span> Null Values to N

* Calculates null values for fields with YESNO domain as `N`.

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.

#### <span class="calculate">Calculate</span> `RCLMatch` and `RCLSide`

* Requires the `RCLMatch` field. First, dataframes are created for the Address Point and Road Centerline featuer classes. Next, the [street fields] concatenated strings for each feature class. Then, the Road Centerline dataframe is joined to the Address Point dataframe using the [street fields] concatenated string. Non-matched address objects are then removed from the joined dataframe. Next, the `AddNumber` field value is then compare to the range of `Add_`[side]`_From` value to `Add_`[side]`_To` value with the `Partiy_`[side] used to determine the step number; this will determine the [side] of the road (`RCLSide`). Non-matches are then removed from the joined dataframe. The `PreNum` value is then compare the both `Add_`[side]`_Pre` value, and the `MSAGComm` field value is compared to the `MSAGComm_`[side] value. Once these comparisons are complete, the possible matches are returned. If only one match is returned, the `NGUID_RDCL` value is returned as `RCLMatch`. Values that results with ties start with the string `TIES` with the `NGUID_RDCL` values returned as a pipe-separated `local:agency` string. `RCLSide` is set to `NO MATCH` The rest of the non-matched values are populated as `NO MATCH`. 

##### Usage (con't.)

* N/A

#### <span class="calculate">Calculate</span> `MSAGComm`

* Calculate `MSAGComm` field for Address Point feature class and `MSAGComm_`[side] fields for Road Centerline feature class.

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.

#### <span class="convert">Convert</span> Type (Legacy or Next-Gen)

* Convert Type [next-gen fields]/[legacy fields] based on the [variant options]. The Legacy option calculates the [legacy fields] from the [next-gen fields], while the Next-Gen option calculates the [next-gen fields] from the [legacy fields].

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.
* Select one of the [variant options] for analysis. 

#### <span class="convert">Convert</span> Direction (Legacy or Next-Gen)

* Convert Direction [next-gen fields]/[legacy fields] based on the [variant options]. The Legacy option calculates the [legacy fields] from the [next-gen fields], while the Next-Gen option calculates the [next-gen fields] from the [legacy fields].

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.
* Select one of the [variant options] for analysis. 

#### <span class="fix">Fix</span> Leading/Trailing Spaces

* Fix leading/trailing spaces in fields with TEXT type.

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.

#### <span class="fix">Fix</span> Domain Case

* Fix values that match values in domain.

##### Usage (con't.)

* Select at least one of the Standard feature class names for analysis.

#### <span class="fix">Fix</span> Level Fields

* Fix FromLevel and/or ToLevel fields from number-version to text-version to match domain in Road Centerline feature class.

##### Usage (con't.)

* Select at least one of the Standard field names for analysis.

## Support Contact
For issues or questions, please contact through email Riley Baird at <rbaird@odot.org> or Emma Baker at <ebaker@odot.org> with the Oklahoma Transportation Cabinet, and please include in the email which script you were running, any error messages, and a zipped copy of your geodatabase. Change the file extension from `zip` to `piz` so it gets through the email server. If there are further data transfer issues, contact Emma or Riley to make alternative data transfer arrangements.

## Disclaimer
The Oklahoma NG9-1-1 GIS Toolbox is provided by the Oklahoma Geographic Information (GI) Council, Oklahoma 9-1-1 Management Authority, Oklahoma Department of Transportation (ODOT), Oklahoma Office of Geographic Information (OGI) , and associated contributors "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed.  In no event shall the Oklahoma GI Council, Oklahoma 9-1-1 Management Authority, ODOT, OGI, or associated contributors be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.

<!-- External Doc links -->
[Prep]: Prep.html
[Adjustment]: Adjustment.html
[Comparison]: Comparison.html
[Enhancement]: Enhancement.html
[MSAG]: MSAG.html
[Submission]: Submission.html
[Validation]: Validation.html
[Topology Rules]: Topology.html
[Change Log]: ../ChangeLog.html
[Error Glossary]: ErrorGlossary.html
[Examples]: Examples.html
[Generate Fishbone Analysis]: FishboneAddressVerification.html
<!-- Internal Doc links -->
[street fields]: <#street-fields>
[next-gen fields]: <#next-gen-fields>
[legacy fields]: <#legacy-fields>
[side]: <#side-for-roads>
[variant options]: <#variant-options>
<!-- CSS for styling by class -->
<style>
.convert, .calculate, .fix, .slash_str {
    padding-left: 4px;
    padding-right: 4px;
    border-radius: 9px;
    vertical-align: text-middle;
    font-size: 11pt;
}
.calculate {
    color:rgb(223, 154, 7);
    background-color:rgb(251, 255, 20);
    border: 2px solid rgb(223, 154, 7);
}
.convert {
    color:rgb(3, 0, 153);
    background-color:rgb(33, 214, 184);
    border: 2px solid rgb(3, 0, 153);
}
.fix {
    color:rgb(185, 35, 35);
    background-color:rgb(247, 160, 160);
    border: 2px solid rgb(185, 35, 35);
}
.slash_str {
    color:rgb(0, 0, 0);
    background-color:rgb(122, 122, 122);
    border: 2px solid rgb(0, 0, 0);
}
</style>